﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// For graphics, canvas, controls
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Media.Animation;
using Windows.UI.Xaml.Shapes;


namespace MetroLightsOut
{
    class Game
    {
        // used for game logic and rendering
        private int _rows, _cols;               

        private Level theLevel;

        private Rectangle[][] _squares;
        private Canvas _canvas;        

        // used to enable the level editor (blank level)
        static private bool _enableLevelEditor = false;

        // used for canvas / screen calculations
        private double _height, _width, _margin;       

        // used for board calculations
        private double _leftBoardBound, _topBoardBound, _squareMargin, _squareSize;
        
        public Game(int rows, int cols, ref Canvas c)
        {            
            // TODO: validate variables
            // 
            _rows = rows;
            _cols = cols;            

            _squares = new Rectangle[rows][];                        

            // setup canvas
            _canvas = c;
            //c.Background = new SolidColorBrush(Colors.White);
            _height = Window.Current.Bounds.Bottom;
            _width  = Window.Current.Bounds.Right;
            _canvas.Width = _width;
            _canvas.Height = _height;

            for (int row = 0; row < rows; row++)
            {
                _squares[row] = new Rectangle[cols];
            }

            theLevel = new Level(rows, cols, ref _squares);

            SetupBoard();
            theLevel.SetupLevel();
        }
       

        void SetupBoard()
        {
            // evenly divide screen by rows / cols
            _margin = _height < _width ? _height / 10 : _width / 10;                        
            
            _height -= _margin;
            _width -= _margin;
            
            double rowSize    = _height / _rows;
            double colSize    = _width / _cols;

            _squareSize = rowSize < colSize ? rowSize : colSize;

            _squareMargin = _squareSize / 5;

            _squareSize -= _squareMargin;

            double bigSidePad = (_height > _width) ? ((_height - _width) / 2) : ((_width - _height) / 2);
            
            // which is the smaller one? used to make grid square vs screen-bound geometry            
            _leftBoardBound = _margin / 2 + (_height < _width ? bigSidePad : 0);
            _topBoardBound  = _margin / 2 + (_width < _height ? bigSidePad : 0);
            
            for (int row = 0; row < _rows; row++){
                for (int col = 0; col < _cols; col++)
                {
                    SetupSquare(row, col);
                }
            }
        }

        void SetupSquare(int row, int col)
        {                        
            // calculate and set left, top, and size 
            double left = _leftBoardBound + (_squareSize * row) + (_squareMargin * row);
            double top = _topBoardBound + (_squareSize * col) + (_squareMargin * col);

            // Create the rect
            Rectangle toAdd = new Rectangle();
            toAdd.Fill = ColorHelper.getOffBrush();            
            toAdd.Width = _squareSize;
            toAdd.Height = _squareSize;
            toAdd.Name = "R" + row.ToString() + "C" + col.ToString();

            _canvas.Children.Add(toAdd);
            
            //Canvas.SetTop(toAdd, top);
            //Canvas.SetLeft(toAdd, left);

            double begintime = (row+(col*_rows)) * 50;

            _squares[row][col] = toAdd;

            startupAnimation(begintime ,left, top, toAdd);

            // set handler for click event
            toAdd.PointerPressed += new Windows.UI.Xaml.Input.PointerEventHandler(toAdd_PointerPressed);
        }               

        void toAdd_PointerPressed(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            for (int row = 0; row < _rows; row++)
            {
                for (int col = 0; col < _cols; col++)
                {
                    if (_squares[row][col] == (Rectangle)sender)
                    {
                        theLevel.toggleSq(row, col);
                        if (theLevel.isComplete() && !_enableLevelEditor)
                        {
                            LevelComplete();
                        }
                        return;
                    }
                }
            }
        }



        void LevelComplete()
        {            
            // Ligth 'em up!
            for (int row = 0; row < _rows; row++)
            {
                for (int col = 0; col < _cols; col++)
                {
                    if (theLevel.querySquare(row, col) == 1)
                    {
                        // ASSERT THIS SHOULD FAIL, lights are out, right?
                        throw new Exception("I thought the lights were out...");
                    }
                    theLevel.toggleSqHelper(row, col);
                    
                    /*for (int i = 0; i < 100000; i++)
                    {
                        
                    }*/                   
                }
            }

            // Turn 'em down
            for (int row = 0; row < _rows; row++)
            {
                for (int col = 0; col < _cols; col++)
                {
                    if (theLevel.querySquare(row,col) == 0)
                    {
                        // ASSERT THIS SHOULD FAIL
                        throw new Exception("I thought the lights were on...");
                    }
                    theLevel.toggleSqHelper(row, col);
                }
            }            
            theLevel.NextLevel();
        }

        void startupAnimation(double begintime, double xpos, double ypos, Rectangle target)
        {
            Storyboard storyboard = new Storyboard();
            DoubleAnimation da = new DoubleAnimation();

            da.From = 0;
            da.To = xpos;
            da.Duration = DurationHelper.FromTimeSpan(TimeSpan.FromMilliseconds(500));
            da.EnableDependentAnimation = true;            
            da.EasingFunction = new PowerEase();

            da.BeginTime = TimeSpan.FromMilliseconds(begintime);

            TranslateTransform tt = new TranslateTransform();            

            tt.Y = ypos;
            tt.X = 0;

            target.RenderTransform = tt;

            Storyboard.SetTarget(da, tt);
            Storyboard.SetTargetProperty(da, "X");

            storyboard.Children.Add(da);

            storyboard.Begin();
        }
       
    }
}

