﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// For graphics, canvas, controls
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Media.Animation;
using Windows.UI.Xaml.Shapes;

namespace MetroLightsOut
{
    class Level
    {
        private int[][] _gameBoard;
        private bool _enableLevelEditor;
        private int _rows, _cols, _level;        
        private Rectangle[][] _squares;

        // used for turning squares back
        private Queue<Rectangle> _colorBackQueue;

        public Level(int rows, int cols, ref Rectangle[][] squares)
        {
            _rows = rows;
            _cols = cols;
            _squares = squares;
            _level = 0;
            _gameBoard = new int[rows][];
            _enableLevelEditor = false;

            _colorBackQueue = new Queue<Rectangle>();

            for (int row = 0; row < _rows; row++)
            {
                _gameBoard[row] = new int[_cols];
            }
        }

        public bool isComplete()
        {                    
            int count = 0;
            // if using "all on" game end
            //int total = 0;
            for (int row = 0; row < _rows; row++)
            {
                for (int col = 0; col < _cols; col++)
                {
                    count += _gameBoard[row][col];
                    //total++;
                }
            }
            // if using "all on" game end
            // return (total == count);
            return (count == 0);
        }

        public int toggleSquare(int row, int col)
        {
            // flip the square bit
            if (_gameBoard[row][col] == 0)
            {
                _gameBoard[row][col] = 1;
                return 1;
            }
            else
            {
                _gameBoard[row][col] = 0;
                return 0;
            }
        }

        public int querySquare(int row, int col)
        {
            return _gameBoard[row][col];
        }

        public void NextLevel()
        {
            _level++;
            SetupLevel();
        }
        
        public void toggleSq(int row, int col)
        {
            toggleSqHelper(row, col);
            toggleSqHelper(row - 1, col);
            toggleSqHelper(row + 1, col);
            toggleSqHelper(row, col + 1);
            toggleSqHelper(row, col - 1);

        }

        public void toggleSqHelper(int row, int col)
        {
            if (row < 0 || row >= _rows)
            {
                return;
            }
            if (col < 0 || col >= _cols)
            {
                return;
            }

            int onOff = toggleSquare(row, col);

            Rectangle curr = _squares[row][col];

            // Do the animation that flips between colors
            Storyboard storyboard = new Storyboard();
            ColorAnimation ca = new ColorAnimation();

            PowerEase pe = new PowerEase();
            pe.EasingMode = EasingMode.EaseInOut;
            ca.EasingFunction = pe;

            Color from, to;
            SolidColorBrush brush = new SolidColorBrush();

            if ((onOff == 1))
            {
                // set curr fill to a solid color for animation (otherwise get a type error because SolidBrush != GradientBrush)
                curr.Fill = new SolidColorBrush(Colors.Blue);
                from = Colors.Blue;
                to = Colors.White;
            }
            else
            {
                // set curr fill to a solid color for animation (otherwise get a type error because SolidBrush != GradientBrush)
                curr.Fill = new SolidColorBrush(Colors.White);
                from = Colors.White;
                to = Colors.Blue;
            }
            ca.EnableDependentAnimation = true;
            ca.From = from;
            ca.To = to;

            Storyboard.SetTarget(ca, curr.Fill);
            Storyboard.SetTargetProperty(ca, "Color");

            ca.Duration = DurationHelper.FromTimeSpan(TimeSpan.FromMilliseconds(250));

            storyboard.Children.Add(ca);

            _colorBackQueue.Enqueue(curr);

            storyboard.Completed += new Windows.UI.Xaml.EventHandler(storyboard_Completed);

            storyboard.Begin();
        }

        void storyboard_Completed(object sender, object e)
        {
            Rectangle curr = _colorBackQueue.Dequeue();
            for (int row = 0; row < _rows; row++)
            {
                for (int col = 0; col < _cols; col++)
                {
                    if (_squares[row][col] == curr)
                    {
                        // Put the gradient brush back
                        if (querySquare(row, col) == 1)
                        {
                            _squares[row][col].Fill = ColorHelper.getOnBrush();
                        }
                        else
                        {
                            _squares[row][col].Fill = ColorHelper.getOffBrush();
                        }
                        return;
                    }
                }
            }
        }

        //TODO: put this somewhere else, perhaps in an external config
        public void SetupLevel()
        {
            int[][] theLevel = new int[_rows][];
            for (int row = 0; row < _rows; row++)
            {
                theLevel[row] = new int[_cols];
            }

            if (_enableLevelEditor) { return; }

            if (_level == 0)
            {
                theLevel[3][3] = 1;
            }

            if (_level == 1)
            {
                theLevel[3][3] = 1;
                theLevel[5][5] = 1;
            }

            if (_level == 2)
            {
                theLevel[3][3] = 1;
                theLevel[4][4] = 1;
            }

            if (_level == 3)
            {
                theLevel[2][3] = 1;
                theLevel[2][4] = 1;
                theLevel[2][5] = 1;
                theLevel[1][1] = 1;
                theLevel[1][6] = 1;
                theLevel[5][1] = 1;
                theLevel[5][5] = 1;
            }

            if (_level == 4)
            {
                theLevel[0][1] = 1;
                theLevel[1][0] = 1;
                theLevel[1][1] = 1;
                theLevel[1][2] = 1;
                theLevel[2][1] = 1;
            }

            if (_level == 5)
            {
                theLevel[0][1] = 1;
                theLevel[1][0] = 1;
                theLevel[1][1] = 1;
                theLevel[1][2] = 1;
                theLevel[2][1] = 1;

                theLevel[4][5] = 1;
                theLevel[5][4] = 1;
                theLevel[5][5] = 1;
                theLevel[5][6] = 1;
                theLevel[6][5] = 1;
            }

            if (_level == 6)
            {
                theLevel[0][1] = 1;
                theLevel[1][0] = 0;
                theLevel[1][1] = 1;
                theLevel[1][2] = 1;
                theLevel[2][1] = 1;

                theLevel[4][5] = 1;
                theLevel[5][4] = 1;
                theLevel[5][5] = 1;
                theLevel[5][6] = 0;
                theLevel[6][5] = 1;
            }

            if (_level == 7)
            {
                theLevel[0][0] = 1;
                theLevel[0][7] = 1;
                theLevel[7][0] = 1;
                theLevel[7][7] = 1;
                theLevel[1][2] = 1;
                theLevel[5][6] = 1;
                theLevel[1][4] = 1;
                theLevel[4][2] = 1;
                theLevel[7][3] = 1;
            }

            if (_level == 8)
            {
                theLevel[1][1] = 1;
                theLevel[5][1] = 1;
                theLevel[1][3] = 1;
                theLevel[5][3] = 1;
                theLevel[1][5] = 1;
                theLevel[5][5] = 1;
            }

            for (int row = 0; row < _rows; row++)
            {
                for (int col = 0; col < _cols; col++)
                {
                    if (theLevel[row][col] == 1)
                    {
                        toggleSq(row, col);
                    }
                }
            }

            LevelSolver ls = new LevelSolver(this);
            ls.Solve();
        }

        // some accessors for the solver
        public int[][] getGameBoard()
        {
            return _gameBoard;
        }
        public int getRows()
        {
            return _rows;
        }
        public int getCols()
        {
            return _cols;
        }
    }
}
