﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Media.Animation;
using Windows.UI.Xaml.Shapes;
namespace SimonSaid
{    

    class Game
    {
        // UI from the mainpage.xaml
        Rectangle redRect, greenRect, blueRect, yellowRect, cheatRect;
        GradientBrush redBrush, greenBrush, blueBrush, yellowBrush;
        MediaElement yellowSound, greenSound, blueSound, redSound;
        Canvas gameCanvas;
        TextBlock statusBox;
        GameState theState;
        Level theLevel;
        int score;

        // configuration variables, toTweak
        const float lowOpacity = .75f;
        const float hiOpacity = 1.0f;

        // for spinning the board
        double centerX, centerY, boardRotation = 0.0;

        // unused, debug, experimental
        // Should be calculated based on screen size
        const int radiusX = 50;
        const int radiusY = 50;

        public Game(ref Canvas _gameCanvas, 
                    ref MediaElement _redSound, 
                    ref MediaElement _yellowSound, 
                    ref MediaElement _blueSound, 
                    ref MediaElement _greenSound, 
                    ref TextBlock _statusBox ){
            redSound = _redSound;
            yellowSound = _yellowSound;
            blueSound = _blueSound;
            greenSound = _greenSound;
            statusBox = _statusBox;
            gameCanvas = _gameCanvas;

            theState = GameState.notRunning;
            score    = 0;
        }

        public void resetGame()
        {
            theState = GameState.notRunning;
            score = 0;
            boardRotation = 0;
            rotateBoard(0);
            if (!(theLevel == null))
            {
                theLevel.resetLevel();
            }
        }

        public int getDifficulty()
        {
            return theLevel.getDifficulty();
        }

        public void addScore(int _score )
        {
            score += _score;
        }

        public int getScore()
        {
            return score;
        }

        public void addLevel()
        {
            theLevel.add(this);
        }

        public Level getLevel()
        {
            return theLevel;
        }

        public void setLevel(ref Level _theLevel)
        {
            theLevel = _theLevel;
        }

        public void setState(GameState _theState)
        {
            theState = _theState;
        }

        public GameState getState()
        {
            return theState;
        }

        public void LevelUp(ref TextBlock _statusBox){
            if (theLevel == null)
            {
                theLevel = new Level(1,ref _statusBox);
            }
            else
            {
                theLevel.nextLevel();
            }
            theState = GameState.challengeUser;
        }

        public void SetupSquare(Rectangle r, double rectWidth, double rectHeight, GradientBrush br, double offset1, double offset2, double rotation, Color c)
        {
            // really annoying code for creating the gradients
            GradientStop grPri = new GradientStop();
            grPri.Color = c;
            grPri.Offset = offset1;
            GradientStop grrBlk = new GradientStop();
            grrBlk.Color = Colors.Black;
            grrBlk.Offset = offset2;

            br.GradientStops.Add(grPri);
            br.GradientStops.Add(grrBlk);

            RotateTransform gRot = new RotateTransform();
            gRot.Angle = rotation;
            br.Transform = gRot;
            // END gradient code


            r.Fill = br;
            r.Height = rectHeight;
            r.Width = rectWidth;
            //r.RadiusX = rectWidth/6;
            //r.RadiusY = rectHeight/6;
        }

        public void SetSquareOrientation(Windows.Graphics.Display.DisplayOrientations orientation)
        {

            // this is dead simple, width becomes height, height becomes width for all squares
            Rectangle current;

            foreach (GameSwitches gameSwitch in Enum.GetValues(typeof(GameSwitches)))
            {
                switch (gameSwitch)
                {
                    // bottom left triangle
                    case GameSwitches.blue:
                        current = blueRect;
                        break;
                    // top right triangle
                    case GameSwitches.green:
                        current = greenRect;                        
                        break;
                    // top right triangle
                    case GameSwitches.red:
                        current = redRect;                        
                        break;
                    // bottom right triangle
                    case GameSwitches.yellow:
                        current = yellowRect;
                        break;
                    default:
                        // impossible?
                        current = null;
                        break;
                }
                double width   = current.Width;
                double height  = current.Height;
                double xPos    = Canvas.GetLeft(current);
                double yPos    = Canvas.GetTop(current);
                current.Width  = height;
                current.Height = width;
                Canvas.SetLeft(current, yPos);
                Canvas.SetTop(current, xPos);
            }
        }

        public void SetupSquares()
        {

            //  -------------
            // | R    |  G   |  
            // |______|______|      
            // | B    |  Y   |
            // |______|______|
            //            
            // All linear gradients are calculated with outer gradient pointing inward

            double height = Window.Current.Bounds.Bottom;
            double width = Window.Current.Bounds.Right;

            double rectWidth = width / 3;  // thirds of the screen for rect width
            double rectHeight = height / 3; // thirds of the screen for height

            double rectSpacing = 15;

            double wMid = rectWidth / 2;    // midpoints for width/height for rect placement
            double hMid = rectHeight / 2;

            centerX = ((wMid * 2) + rectSpacing) / 2; // between the rectangles
            centerY = ((hMid * 2) + rectSpacing) / 2;

            // Just a little easter egg for cheating
            cheatRect = new Rectangle();
            Canvas.SetLeft(cheatRect, 0);
            Canvas.SetTop(cheatRect, 0);
            cheatRect.Width = 50;
            cheatRect.Height = 50;
            cheatRect.Fill = new SolidColorBrush(Colors.Transparent);
            cheatRect.PointerPressed += new Windows.UI.Xaml.Input.PointerEventHandler(cheatRect_PointerPressed);
            gameCanvas.Children.Add(cheatRect);

            redRect = new Rectangle();
            redBrush = new LinearGradientBrush();

            SetupSquare(redRect, rectWidth, rectHeight, redBrush, 0.0, 1.5, 0.0, Colors.Red);

            Canvas.SetTop(redRect, hMid);
            Canvas.SetLeft(redRect, wMid);

            gameCanvas.Children.Add(redRect);

            greenRect = new Rectangle();
            greenBrush = new LinearGradientBrush();

            SetupSquare(greenRect, rectWidth, rectHeight, greenBrush, 0.0, 1.5, 90.0, Colors.Green);

            Canvas.SetTop(greenRect, hMid);
            Canvas.SetLeft(greenRect, wMid + rectWidth + rectSpacing);

            gameCanvas.Children.Add(greenRect);

            blueRect = new Rectangle();
            blueBrush = new LinearGradientBrush();

            SetupSquare(blueRect, rectWidth, rectHeight, blueBrush, 1.0, -.5, -90.0, Colors.Blue);

            blueRect.Fill = blueBrush;
            blueRect.Height = rectHeight;
            blueRect.Width = rectWidth;

            Canvas.SetTop(blueRect, hMid + rectHeight + rectSpacing);
            Canvas.SetLeft(blueRect, wMid);

            gameCanvas.Children.Add(blueRect);

            yellowRect = new Rectangle();
            yellowBrush = new LinearGradientBrush();

            SetupSquare(yellowRect, rectWidth, rectHeight, yellowBrush, 1.0, -0.5, 0.0, Colors.Orange);

            Canvas.SetTop(yellowRect, hMid + rectHeight + rectSpacing);
            Canvas.SetLeft(yellowRect, wMid + rectWidth + rectSpacing);

            gameCanvas.Children.Add(yellowRect);

            // set all opacity down
            redRect.Opacity = lowOpacity;
            greenRect.Opacity = lowOpacity;
            blueRect.Opacity = lowOpacity;
            yellowRect.Opacity = lowOpacity;

            // Add event handlers for each button click
            redRect.PointerPressed += new Windows.UI.Xaml.Input.PointerEventHandler(redRect_PointerPressed);
            redRect.PointerReleased += new Windows.UI.Xaml.Input.PointerEventHandler(redRect_PointerReleased);
            redRect.PointerEntered += new Windows.UI.Xaml.Input.PointerEventHandler(genericPointerEntered);
            redRect.PointerExited += new Windows.UI.Xaml.Input.PointerEventHandler(genericPointerExited);

            greenRect.PointerPressed += new Windows.UI.Xaml.Input.PointerEventHandler(greenRect_PointerPressed);
            greenRect.PointerReleased += new Windows.UI.Xaml.Input.PointerEventHandler(greenRect_PointerReleased);
            greenRect.PointerEntered += new Windows.UI.Xaml.Input.PointerEventHandler(genericPointerEntered);
            greenRect.PointerExited += new Windows.UI.Xaml.Input.PointerEventHandler(genericPointerExited);

            blueRect.PointerPressed += new Windows.UI.Xaml.Input.PointerEventHandler(blueRect_PointerPressed);
            blueRect.PointerReleased += new Windows.UI.Xaml.Input.PointerEventHandler(blueRect_PointerReleased);
            blueRect.PointerEntered += new Windows.UI.Xaml.Input.PointerEventHandler(genericPointerEntered);
            blueRect.PointerExited += new Windows.UI.Xaml.Input.PointerEventHandler(genericPointerExited);

            yellowRect.PointerPressed += new Windows.UI.Xaml.Input.PointerEventHandler(yellowRect_PointerPressed);
            yellowRect.PointerReleased += new Windows.UI.Xaml.Input.PointerEventHandler(yellowRect_PointerReleased);
            yellowRect.PointerEntered += new Windows.UI.Xaml.Input.PointerEventHandler(genericPointerEntered);
            yellowRect.PointerExited += new Windows.UI.Xaml.Input.PointerEventHandler(genericPointerExited);
        }

        void cheatRect_PointerPressed(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theLevel != null) theLevel.toggleCheat();
        }

        // Rotate the entire board
        public void rotateBoard(double degrees)
        {
            boardRotation += degrees;

            Rectangle current;

            foreach (GameSwitches gameSwitch in Enum.GetValues(typeof(GameSwitches)))
            {
                switch (gameSwitch)
                {
                    // bottom left triangle
                    case GameSwitches.blue:
                        current = blueRect;
                        centerX = blueRect.ActualWidth;
                        centerY = 0;
                        break;
                    // top right triangle
                    case GameSwitches.green:
                        current = greenRect;
                        centerX = 0;
                        centerY = greenRect.ActualHeight;
                        break;
                    // top right triangle
                    case GameSwitches.red:
                        current = redRect;
                        centerX = redRect.ActualWidth;
                        centerY = redRect.ActualHeight;
                        break;
                    // bottom right triangle
                    case GameSwitches.yellow:
                        current = yellowRect;
                        centerX = 0;
                        centerY = 0;
                        break;
                    default:
                        // impossible?
                        current = null;
                        break;
                }
                CompositeTransform transform = new CompositeTransform();
                transform.CenterX = centerX;
                transform.CenterY = centerY;
                transform.Rotation = boardRotation;

                current.RenderTransform = transform;            
            }
        }


        // trigger sound + color
        public void triggerOnYellow()
        {            
            yellowRect.Fill = new SolidColorBrush(Colors.Orange);
            yellowSound.Play();            
        }
        public void triggerOffYellow()
        {
            yellowRect.Fill = yellowBrush;
        }

        public void triggerOnBlue()
        {            
            blueRect.Fill = new SolidColorBrush(Colors.Blue);
            blueSound.Play();
        }
        public void triggerOffBlue()
        {
            blueRect.Fill = blueBrush;
        }

        public void triggerOnGreen()
        {            
            greenRect.Fill = new SolidColorBrush(ColorHelper.FromArgb(255, 0, 255, 0));
            greenSound.Play();
        }
        public void triggerOffGreen()
        {
            greenRect.Fill = greenBrush;
        }

        public void triggerOnRed()
        {            
            redRect.Fill = new SolidColorBrush(Colors.Red);
            redSound.Play();

        }
        public void triggerOffRed()
        {
            redRect.Fill = redBrush;            
        }

        public void stopAllSounds()
        {
            redSound.Stop();
            blueSound.Stop();
            yellowSound.Stop();
            greenSound.Stop();
        }

        public void triggerAllSounds()
        {
            redSound.Play();
            blueSound.Play();
            yellowSound.Play();
            greenSound.Play();
        }

        public void doLevelComplete()
        {
            triggerOffBlue();
            triggerOffGreen();
            triggerOffRed();
            triggerOffYellow();
            setState(GameState.levelComplete);
        }

        public void doLevelFail()
        {
            triggerOffBlue();
            triggerOffGreen();
            triggerOffRed();
            triggerOffYellow();
            setState(GameState.levelFailed);
        }

        // Highlight glow / etc
        void genericPointerEntered(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            ((Rectangle)sender).Opacity = hiOpacity;
        }

        void genericPointerExited(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            ((Rectangle)sender).Opacity = lowOpacity;
        }

        // Click / unclick
        // TODO: encapsulate this in the class to make it possible to just call some
        // methods on self, reduce defects, etc.
        void yellowRect_PointerReleased(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            triggerOffYellow();            
        }

        void yellowRect_PointerPressed(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            triggerOnYellow();            
            if (!theLevel.solve(GameSwitches.yellow)){
                theState = GameState.levelFailed;
            } 
            else
            {
                addScore(theLevel.getDifficulty());
                if (theLevel.isComplete()){
                    addScore(theLevel.getDifficulty() * 100);
                    doLevelComplete();    
                }
            }
        }

        void blueRect_PointerReleased(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            triggerOffBlue();
        }

        void blueRect_PointerPressed(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            triggerOnBlue();
            if (!theLevel.solve(GameSwitches.blue)){
                theState = GameState.levelFailed;
            }
            else
            {
                addScore(theLevel.getDifficulty());
                if (theLevel.isComplete())
                {
                    addScore(theLevel.getDifficulty() * 100);
                    doLevelComplete();
                }
            }
        }

        void greenRect_PointerReleased(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            triggerOffGreen();
        }

        void greenRect_PointerPressed(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            triggerOnGreen();
            if (!theLevel.solve(GameSwitches.green)){
                theState = GameState.levelFailed;
            }
            else
            {
                addScore(theLevel.getDifficulty());
                if (theLevel.isComplete())
                {
                    addScore(theLevel.getDifficulty() * 100);
                    doLevelComplete();
                }
            }

        }

        void redRect_PointerReleased(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;
            triggerOffRed();
        }

        void redRect_PointerPressed(object sender, Windows.UI.Xaml.Input.PointerEventArgs e)
        {
            if (theState != GameState.responseUser) return;

            triggerOnRed();
            if (!theLevel.solve(GameSwitches.red)){
                theState = GameState.levelFailed;
            }
            else
            {
                addScore(theLevel.getDifficulty());
                if (theLevel.isComplete())
                {
                    addScore(theLevel.getDifficulty() * 100);
                    doLevelComplete();
                }
            }
        }

    }
}
