﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Windows.System.Display;

using Windows.UI.Xaml.Controls;

namespace SimonSaid
{
    class Level
    {
        // some configuration stuff
        bool levelRandom = false; // random levels every time...
        bool cheat = false;

        // member variables
        int difficulty, chimesAdded, lastQueued;
        Queue<int> triggers, prevTriggers;
        
        Random randNum;
        bool levelCreated  = false;
        bool levelComplete = false;

        // externals
        TextBlock statusBlock;        

        public Level(int _difficulty, ref TextBlock _statusBlock)
        {
            chimesAdded = 0;
            lastQueued = -1;
            difficulty = _difficulty;
            statusBlock = _statusBlock;

            if (cheat)
            {
                statusBlock.Text = "Cheating: ";
            }

            triggers = new Queue<int>();
            prevTriggers = new Queue<int>();

            randNum = new Random(DateTime.Now.Millisecond);
        }

        public void toggleCheat()
        {
            if (cheat)
            {
                cheat = false;
            }
            else
            {
                cheat = true;
            }
        }

        public int getDifficulty()
        {
            return difficulty;
        }

        public bool isComplete()
        {
            return levelComplete;
        }

        public bool isCreated()
        {
            return levelCreated;            
        }

        // returns false after the level is done being created
        public bool add(Game theGame)
        {            
            // the following logic exists to turn off the switch after the level is created
            switch (lastQueued)
            {
                case ((int)GameSwitches.blue):
                    theGame.triggerOffBlue();
                    break;
                case ((int)GameSwitches.green):
                    theGame.triggerOffGreen();
                    break;
                case ((int)GameSwitches.red):
                    theGame.triggerOffRed();
                    break;
                case ((int)GameSwitches.yellow):
                    theGame.triggerOffYellow();
                    break;
                default:
                    // do nothing, we could do weird stuff for fun
                    break;
            }
            if (chimesAdded >= difficulty) levelCreated = true;
            if (isCreated())
            {
                return false;
            }
            // end weird logic     

            // the following code adds the "challenge" to the level
            chimesAdded++;
            int trigger = randNum.Next(0, 4);
            if (prevTriggers.Count() != 0)
            {
                trigger = prevTriggers.Dequeue();
            }            
            
            triggers.Enqueue(trigger);
            lastQueued = trigger;
            switch (trigger)
            {
                // TODO: does the implicit enum conversion really work?
                case ((int)GameSwitches.blue):
                    if (cheat) statusBlock.Text += "Blue ";
                    theGame.triggerOnBlue();                    
                    break;
                case ((int)GameSwitches.green):
                    if (cheat) statusBlock.Text += "Green ";
                    theGame.triggerOnGreen();
                    break;
                case ((int)GameSwitches.red):
                    if (cheat) statusBlock.Text += "Red ";
                    theGame.triggerOnRed();
                    break;
                case ((int)GameSwitches.yellow):
                    if (cheat) statusBlock.Text += "Yellow";
                    theGame.triggerOnYellow();
                    break;
                default:
                    // in case of glitch, mess up the player
                    theGame.triggerAllSounds();
                    break;
            }            
            return true;
        }

        public bool solve(GameSwitches trigger)
        {
            // ???
            if (triggers.Count == 0)
            {
                levelComplete = true;
                return true;                
            }


            int challenge = triggers.Dequeue();

            prevTriggers.Enqueue(challenge);

            // guilty until proven innocent
            bool correct = false;
            if (challenge == ((int)trigger))
            {
                correct = true;
            }
            
            if (triggers.Count == 0){
                levelComplete = true;
            }

            return correct;
        }

        public void nextLevel()
        {
            // up the difficulty and reseed
            difficulty++;
            randNum = new Random(DateTime.Now.Millisecond);

            if (levelRandom)
            {
                // just want all the next ones to be random
                prevTriggers.Clear();
            }

            chimesAdded   = 0;
            levelComplete = false;
            levelCreated  = false;            
        }

        public void resetLevel()
        {
            chimesAdded = 0;
            levelComplete = false;
            levelCreated = false;
            difficulty = 0;
            triggers = new Queue<int>();
            prevTriggers = new Queue<int>();
            randNum = new Random(DateTime.Now.Millisecond);

            if (cheat)
            {
                statusBlock.Text = "Cheating: ";
            }
        }
    }
}
