﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using Windows.Foundation;

using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media.Animation;

// for orientation
using Windows.Devices.Sensors;

namespace SimonSaid
{
    enum GameSwitches { red = 0, blue = 1, green = 2, yellow = 3};
    enum GameState { challengeUser = 0, responseUser = 1, notRunning = 2, levelComplete = 3, levelFailed = 4};
   
    partial class MainPage
    {
        // Game variables        
        Game  theGame;        
        Storyboard _gameLoop = new Storyboard();

        // constants
        // 
        const int startCurrentSpeed = 90;

        // TODO: Move all this logic into game
        int initialWait      = 60;                  // remove race condition for first trigger               
        int currentSpeed     = startCurrentSpeed;   // lower value = higher speed
        int minSpeedValue    = 50;                  // the minimum speed "value" lower = faster, this is limited by UI
   
        // Variables used in fundamentals
        SimpleOrientationSensor orientationSensor;
        bool useOrientation = false;

        // temp / debug / possible approaches variables
        //DispatcherTimer levelCreateTimer;
        int count = 0;
        bool enableTestFeature = false;
       

        public MainPage()
        {
            InitializeComponent();
            theGame = new Game(ref gameCanvas, ref redSound, ref yellowSound, ref blueSound, ref greenSound, ref statusBox);
            theGame.SetupSquares();
            theGame.setState(GameState.notRunning);
            statusBox.Text = "Click \"New Game\" to begin...";

            Windows.Graphics.Display.DisplayProperties.AutoRotationPreferences = Windows.Graphics.Display.DisplayOrientations.Landscape | Windows.Graphics.Display.DisplayOrientations.LandscapeFlipped;

            Windows.Graphics.Display.DisplayProperties.OrientationChanged += new Windows.Graphics.Display.DisplayPropertiesEventHandler(DisplayProperties_OrientationChanged);
            // TODO: use orientation
            orientationSensor = SimpleOrientationSensor.GetDefault();
            if (orientationSensor != null)
            {
                useOrientation = true;
                orientationSensor.OrientationChanged += new TypedEventHandler<SimpleOrientationSensor, SimpleOrientationSensorOrientationChangedEventArgs>(orientationSensor_OrientationChanged);
            }

            // TODO: doesn't work 
            //levelCreateTimer = new DispatcherTimer();            
        }

        void DisplayProperties_OrientationChanged(object sender)
        {

            theGame.SetSquareOrientation(Windows.Graphics.Display.DisplayProperties.CurrentOrientation);
        }

        void orientationSensor_OrientationChanged(SimpleOrientationSensor sender, SimpleOrientationSensorOrientationChangedEventArgs args)
        {
            SimpleOrientation orientation = orientationSensor.GetCurrentOrientation();

            if (useOrientation)
            switch (orientation)
            {
                case SimpleOrientation.NotRotated:
                    break;
                case SimpleOrientation.Faceup:
                    break;
                case SimpleOrientation.Facedown:
                    break;
                case SimpleOrientation.Rotated180DegreesCounterclockwise:
                    break;
                case SimpleOrientation.Rotated270DegreesCounterclockwise:
                    break;
                case SimpleOrientation.Rotated90DegreesCounterclockwise:
                    break;
                default:
                    break;
            }
        }

        void updateScore()
        {
            scoreBox.Text = "Score: " + theGame.getScore().ToString();
        }

        void updateLevel()
        {
            // restart on first entry
            if (theGame.getLevel() == null) return;

            // normal operation
            levelBox.Text = "Level: " + theGame.getLevel().getDifficulty().ToString() ;
        }

        void GameLoop(object sender, object e)
        {
            if (enableTestFeature)
            {
                // insert fun weird tweaks in here
                // I used to have the rotation code here...
            }

            // If we're Level 5+, start spinning :)
            if (theGame.getLevel() != null && theGame.getLevel().getDifficulty() > 5)
            {
                theGame.rotateBoard(.01 * theGame.getLevel().getDifficulty());
            }


            // TODO, use a proper timer, wth is up with the new threading?            
            switch (theGame.getState()){
                case GameState.challengeUser:
                    statusBox.Text = "Simon is telling you the secret code.";
                    
                    if (theGame.getLevel().isCreated()){
                        theGame.setState(GameState.responseUser);                            
                    }else{
                        // The following condition will ensure we don't pump too fast
                        if ( (count > initialWait) && ((count % currentSpeed) == 0) ) {
                            theGame.addLevel();                            
                        }
                    }
                    break;
                case GameState.levelComplete:
                    statusBox.Text = "Nice work homeslice!  Reward is harder level.";
                                            
                    updateScore();
                    // TODO: using the status box reference is hacky
                    theGame.LevelUp(ref status2Box);
                    updateLevel();

                    // TODO: move into game logic
                    if (currentSpeed > minSpeedValue) currentSpeed -= 5;
                    status2Box.Text = "";
                    break;
                case GameState.levelFailed:
                    statusBox.Text = "You fail. Game over man.";
                    _gameLoop.Stop();
                    AppBar.IsOpen = true;                    
                    break;
                case GameState.responseUser:
                    statusBox.Text = "Simon is waiting for you to enter the code.";
                    updateScore();
                    break;
                case GameState.notRunning:
                    statusBox.Text = "Shall we play a game?";
                    break;
                default:
                    break;                
            }
                        
            count++;          

            _gameLoop.Begin();
        }

        private void NewGameClick(object sender, RoutedEventArgs e)
        {
            // What to do if the game is running?
            if (theGame.getState() == GameState.levelFailed)
            {
                ResetAndPauseGame();
            }

            if (theGame.getState() == GameState.notRunning)
            {

                // level up the user!
                theGame.LevelUp(ref status2Box);

                AppBar.IsOpen = false;
                _gameLoop.Duration = Windows.UI.Xaml.DurationHelper.FromTimeSpan(TimeSpan.FromMilliseconds(0));
                _gameLoop.Completed += new Windows.UI.Xaml.EventHandler(GameLoop);
                _gameLoop.Begin();
            }
        }

        private void RandomClick(object sender, RoutedEventArgs e)
        {
            if (enableTestFeature) { enableTestFeature = false; } else { enableTestFeature = true; };
        }

        private void ResetAndPauseGame()
        {
            statusBox.Text = "Shall we play a game?";
            theGame.resetGame();
            updateLevel();
            updateScore();
            count = 0;
            currentSpeed = startCurrentSpeed;
            _gameLoop.Stop();
        }

        private void ResetGameClick(object sender, RoutedEventArgs e)
        {
            ResetAndPauseGame();
        }

    }

}
